document.addEventListener("DOMContentLoaded", function () {
  const initSlider = () => {
    const sliders = gsap.utils.toArray(".pxl-carousel-hero1");

    sliders.forEach((slider) => {
      const slides   = gsap.utils.toArray(".pxl-bg-hero", slider);
      const contents = gsap.utils.toArray(".pxl-content-slide", slider);
      if (!slides.length || !contents.length) return;

      let currentIndex = 0;
      let timeline;
      let autoSlideTween;
      const delayTime = 4; // seconds
      const duration = 0.8; // seconds

      // init state
      slides.forEach((s, i) => {
        gsap.set(s, {
          opacity: i === 0 ? 1 : 0,
          scale: i === 0 ? 1 : 1.1,
          zIndex: i === 0 ? 2 : 1
        });
      });

      contents.forEach((c, i) => {
        gsap.set(c, {
          autoAlpha: i === 0 ? 1 : 0,
          y: i === 0 ? 0 : 40,
          zIndex: i === 0 ? 5 : 1
        });
      });

      // dots
      const dotsWrapper = slider.querySelector(".pxl-swiper-dots");
      let dots = [];
      if (dotsWrapper) {
        dotsWrapper.innerHTML = "";
        slides.forEach((_, i) => {
          const dot = document.createElement("span");
          dot.classList.add("pxl-dot");
          if (i === 0) dot.classList.add("active");
          dot.addEventListener("click", () => goToSlide(i, true));
          dotsWrapper.appendChild(dot);
          dots.push(dot);
        });
      }

      const updateDots = (i) => {
        dots.forEach((d, idx) => d.classList.toggle("active", idx === i));
      };

      // animation core
      const goToSlide = (nextIndex, stopAuto = false) => {
        if (nextIndex === currentIndex) return;
        if (stopAuto) stopAutoSlide();

        // kill timeline cũ
        if (timeline) timeline.kill();

        // reset tất cả slide & content về state "ẩn"
        slides.forEach((s, i) => {
          gsap.set(s, { opacity: 0, scale: 1.1, zIndex: 1 });
        });
        contents.forEach((c, i) => {
          gsap.set(c, { autoAlpha: 0, y: 40, zIndex: 1 });
        });

        const currentSlide   = slides[currentIndex];
        const nextSlide      = slides[nextIndex];
        const currentContent = contents[currentIndex];
        const nextContent    = contents[nextIndex];

        // set state cho current và next
        gsap.set(currentSlide, { opacity: 1, scale: 1, zIndex: 1 });
        gsap.set(currentContent, { autoAlpha: 1, y: 0, zIndex: 1 });
        gsap.set(nextSlide, { opacity: 0, scale: 1.1, zIndex: 2 });
        gsap.set(nextContent, { autoAlpha: 0, y: 40, zIndex: 5 });

        updateDots(nextIndex);

        timeline = gsap.timeline({
          defaults: { ease: "power2.out" },
          onComplete: () => {
            currentIndex = nextIndex; // update index khi xong
            startAutoSlide();
          }
        });

        // bg
        timeline.to(nextSlide, {
          opacity: 1,
          scale: 1,
          duration: duration
        }, 0);

        // content out + in
        timeline.to(currentContent, {
          autoAlpha: 0,
          y: -40,
          duration: 0.4
        }, 0);
        timeline.to(nextContent, {
          autoAlpha: 1,
          y: 0,
          duration: 0.6
        }, 0.1);
      };

      // auto slide
      const next = () => {
        let nextIndex = (currentIndex + 1) % slides.length;
        goToSlide(nextIndex);
      };
      const prev = () => {
        let prevIndex = (currentIndex - 1 + slides.length) % slides.length;
        goToSlide(prevIndex);
      };

      const startAutoSlide = () => {
        stopAutoSlide();
        autoSlideTween = gsap.delayedCall(delayTime, next);
      };
      const stopAutoSlide = () => {
        if (autoSlideTween) autoSlideTween.kill();
      };

      // hover pause
      slider.addEventListener("mouseenter", stopAutoSlide);
      slider.addEventListener("mouseleave", startAutoSlide);

      // swipe
      let startX = 0;
      slider.addEventListener("touchstart", (e) => {
        startX = e.touches[0].clientX;
      });
      slider.addEventListener("touchend", (e) => {
        let endX = e.changedTouches[0].clientX;
        if (Math.abs(endX - startX) > 50) {
          if (endX < startX) next();
          else prev();
        }
      });

      // init
      startAutoSlide();
    });
  };

  initSlider();
});
