<?php

$html_id = pxl_get_element_id($settings);
if ( ! empty( $settings['button_link_lv1']['url'] ) ) {
    $widget->add_render_attribute( 'button_lv1', 'href', $settings['button_link_lv1']['url'] );

    if ( $settings['button_link_lv1']['is_external'] ) {
        $widget->add_render_attribute( 'button_lv1', 'target', '_blank' );
    }

    if ( $settings['button_link_lv1']['nofollow'] ) {
        $widget->add_render_attribute( 'button_lv1', 'rel', 'nofollow' );
    }
}

if ( ! empty( $settings['button_link_lv2']['url'] ) ) {
    $widget->add_render_attribute( 'button_lv2', 'href', $settings['button_link_lv2']['url'] );

    if ( $settings['button_link_lv2']['is_external'] ) {
        $widget->add_render_attribute( 'button_lv2', 'target', '_blank' );
    }

    if ( $settings['button_link_lv2']['nofollow'] ) {
        $widget->add_render_attribute( 'button_lv2', 'rel', 'nofollow' );
    }
}

$show_new = $widget->get_setting('show_new');
?>
<div class="pxl-showcase pxl-showcase1">
	<div class="pxl-item--inner <?php echo esc_attr($settings['style']); ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
		<div class="pxl-image-bg">
			<div class="pxl-item--image">
				<?php if(!empty($settings['image']['id'])) : 
					$image_size = !empty($settings['img_size']) ? $settings['img_size'] : 'full'; 
					$img = pxl_get_image_by_size( array(
						'attach_id'  => $settings['image']['id'],
						'thumb_size' => $image_size,
					));
					$thumbnail = $img['thumbnail'];
					?>
					<a <?php pxl_print_html($widget->get_render_attribute_string( 'button_lv1' )); ?>>
						<?php echo pxl_print_html($thumbnail); ?>
						<?php if ( ! empty( $settings['title'] ) ) : ?>
			            	<span class="pxl-item--title"><?php echo pxl_print_html($settings['title']); ?></span>
			            <?php endif; ?>
					</a>
				<?php endif; ?>
			</div>		
		</div>


		<div class="pxl-inner-meta">
	        <div class="pxl-item--buttons">
				<?php if(!empty($settings['button_text_lv1'])) : ?>
		            <div class="pxl-item--button">
		                <a class="btn-showcase" <?php pxl_print_html($widget->get_render_attribute_string( 'button_lv1' )); ?>>
		                	<span class="pxl-text">
		                		<?php echo pxl_print_html($settings['button_text_lv1']); ?>
		                	</span>
		                	<span class="pxl-icon">
		                		<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
								  <g clip-path="url(#clip0_9_140)">
								    <path d="M25.5913 13.5249L25.6401 12.7681L25.6157 12.7437C25.6157 12.7437 25.6076 12.7437 25.5913 12.7437C25.575 12.7437 25.5588 12.7437 25.5425 12.7437C25.4937 12.7274 25.4408 12.7152 25.3838 12.707C25.3268 12.6989 25.2658 12.6867 25.2007 12.6704C25.0542 12.6379 24.8792 12.5972 24.6758 12.5483C24.4723 12.4995 24.2404 12.4425 23.98 12.3774C23.4917 12.231 22.9465 12.0275 22.3442 11.7671C21.742 11.5067 21.1479 11.1893 20.562 10.8149C20.0249 10.4406 19.5407 9.97673 19.1094 9.42334C18.6781 8.86995 18.3159 8.31657 18.0229 7.76318C17.8765 7.48649 17.7463 7.23014 17.6323 6.99414C17.5184 6.75814 17.4289 6.55062 17.3638 6.37158C17.3312 6.2902 17.2987 6.21289 17.2661 6.13965C17.2336 6.06641 17.2091 6.00537 17.1929 5.95654C17.1929 5.94027 17.1888 5.91992 17.1807 5.89551C17.1725 5.87109 17.1603 5.85889 17.144 5.85889V5.83447V5.81006C17.144 5.81006 17.1115 5.82227 17.0464 5.84668C16.9813 5.87109 16.7697 5.94027 16.4116 6.0542C16.0373 6.18441 15.8175 6.26172 15.7524 6.28613C15.6873 6.31055 15.6548 6.32275 15.6548 6.32275H15.6792V6.37158C15.6792 6.38786 15.6833 6.4082 15.6914 6.43262C15.6995 6.45703 15.7118 6.47738 15.728 6.49365C15.7443 6.55876 15.7687 6.632 15.8013 6.71338C15.8338 6.79476 15.8745 6.88428 15.9233 6.98193C16.0047 7.17725 16.1064 7.40511 16.2285 7.66553C16.3506 7.92594 16.493 8.21077 16.6558 8.52002C16.9813 9.10596 17.3963 9.73258 17.9009 10.3999C18.4054 11.0672 19.0077 11.6369 19.7075 12.1089C19.8866 12.2228 20.0656 12.3327 20.2446 12.4385C20.4237 12.5443 20.6027 12.646 20.7817 12.7437H0.640137V14.3062H20.7817C20.6027 14.4038 20.4237 14.5055 20.2446 14.6113C20.0656 14.7171 19.8866 14.8351 19.7075 14.9653C19.0077 15.4211 18.4054 15.9867 17.9009 16.6621C17.3963 17.3376 16.9813 17.9683 16.6558 18.5542C16.493 18.8472 16.3506 19.1279 16.2285 19.3965C16.1064 19.665 16.0047 19.897 15.9233 20.0923C15.8745 20.1899 15.8338 20.2795 15.8013 20.3608C15.7687 20.4422 15.7443 20.5073 15.728 20.5562C15.7118 20.5887 15.6995 20.6172 15.6914 20.6416C15.6833 20.666 15.6792 20.6864 15.6792 20.7026L15.6548 20.7515C15.6548 20.7515 15.6873 20.7637 15.7524 20.7881C15.8175 20.8125 16.0373 20.8817 16.4116 20.9956C16.7697 21.1258 16.9813 21.1991 17.0464 21.2153C17.1115 21.2316 17.144 21.2397 17.144 21.2397V21.2153C17.1603 21.1991 17.1725 21.1828 17.1807 21.1665C17.1888 21.1502 17.1929 21.134 17.1929 21.1177C17.2091 21.0688 17.2336 21.0078 17.2661 20.9346C17.2987 20.8613 17.3312 20.7759 17.3638 20.6782C17.4289 20.4992 17.5184 20.2917 17.6323 20.0557C17.7463 19.8197 17.8765 19.5715 18.0229 19.311C18.3159 18.7576 18.6781 18.2002 19.1094 17.6387C19.5407 17.0771 20.0249 16.6174 20.562 16.2593C21.1479 15.8687 21.742 15.5472 22.3442 15.2949C22.9465 15.0426 23.4917 14.8433 23.98 14.6968C24.2404 14.6154 24.4723 14.5503 24.6758 14.5015C24.8792 14.4526 25.0542 14.4119 25.2007 14.3794C25.2658 14.3631 25.3268 14.3509 25.3838 14.3428C25.4408 14.3346 25.4937 14.3306 25.5425 14.3306C25.5588 14.3143 25.575 14.3062 25.5913 14.3062C25.6076 14.3062 25.6157 14.3062 25.6157 14.3062H25.6401L25.5913 13.5249Z" fill="#4E4E53"/>
								  </g>
								  <defs>
								    <clipPath id="clip0_9_140">
								      <rect width="25" height="25" fill="white" transform="matrix(1 0 0 -1 0.640137 25.6099)"/>
								    </clipPath>
								  </defs>
								</svg>
		                	</span>
		                </a>
		            </div>
		        <?php endif; ?>
		        <?php if(!empty($settings['button_text_lv2'])) : ?>
			        <div class="pxl-item--button">
		                <a class="btn-showcase style-lv2" <?php pxl_print_html($widget->get_render_attribute_string( 'button_lv2' )); ?>>
		                	<span class="pxl-text">
		                		<?php echo pxl_print_html($settings['button_text_lv2']); ?>
		                	</span>
		                	<span class="pxl-icon">
		                		<svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
								  <g clip-path="url(#clip0_9_140)">
								    <path d="M25.5913 13.5249L25.6401 12.7681L25.6157 12.7437C25.6157 12.7437 25.6076 12.7437 25.5913 12.7437C25.575 12.7437 25.5588 12.7437 25.5425 12.7437C25.4937 12.7274 25.4408 12.7152 25.3838 12.707C25.3268 12.6989 25.2658 12.6867 25.2007 12.6704C25.0542 12.6379 24.8792 12.5972 24.6758 12.5483C24.4723 12.4995 24.2404 12.4425 23.98 12.3774C23.4917 12.231 22.9465 12.0275 22.3442 11.7671C21.742 11.5067 21.1479 11.1893 20.562 10.8149C20.0249 10.4406 19.5407 9.97673 19.1094 9.42334C18.6781 8.86995 18.3159 8.31657 18.0229 7.76318C17.8765 7.48649 17.7463 7.23014 17.6323 6.99414C17.5184 6.75814 17.4289 6.55062 17.3638 6.37158C17.3312 6.2902 17.2987 6.21289 17.2661 6.13965C17.2336 6.06641 17.2091 6.00537 17.1929 5.95654C17.1929 5.94027 17.1888 5.91992 17.1807 5.89551C17.1725 5.87109 17.1603 5.85889 17.144 5.85889V5.83447V5.81006C17.144 5.81006 17.1115 5.82227 17.0464 5.84668C16.9813 5.87109 16.7697 5.94027 16.4116 6.0542C16.0373 6.18441 15.8175 6.26172 15.7524 6.28613C15.6873 6.31055 15.6548 6.32275 15.6548 6.32275H15.6792V6.37158C15.6792 6.38786 15.6833 6.4082 15.6914 6.43262C15.6995 6.45703 15.7118 6.47738 15.728 6.49365C15.7443 6.55876 15.7687 6.632 15.8013 6.71338C15.8338 6.79476 15.8745 6.88428 15.9233 6.98193C16.0047 7.17725 16.1064 7.40511 16.2285 7.66553C16.3506 7.92594 16.493 8.21077 16.6558 8.52002C16.9813 9.10596 17.3963 9.73258 17.9009 10.3999C18.4054 11.0672 19.0077 11.6369 19.7075 12.1089C19.8866 12.2228 20.0656 12.3327 20.2446 12.4385C20.4237 12.5443 20.6027 12.646 20.7817 12.7437H0.640137V14.3062H20.7817C20.6027 14.4038 20.4237 14.5055 20.2446 14.6113C20.0656 14.7171 19.8866 14.8351 19.7075 14.9653C19.0077 15.4211 18.4054 15.9867 17.9009 16.6621C17.3963 17.3376 16.9813 17.9683 16.6558 18.5542C16.493 18.8472 16.3506 19.1279 16.2285 19.3965C16.1064 19.665 16.0047 19.897 15.9233 20.0923C15.8745 20.1899 15.8338 20.2795 15.8013 20.3608C15.7687 20.4422 15.7443 20.5073 15.728 20.5562C15.7118 20.5887 15.6995 20.6172 15.6914 20.6416C15.6833 20.666 15.6792 20.6864 15.6792 20.7026L15.6548 20.7515C15.6548 20.7515 15.6873 20.7637 15.7524 20.7881C15.8175 20.8125 16.0373 20.8817 16.4116 20.9956C16.7697 21.1258 16.9813 21.1991 17.0464 21.2153C17.1115 21.2316 17.144 21.2397 17.144 21.2397V21.2153C17.1603 21.1991 17.1725 21.1828 17.1807 21.1665C17.1888 21.1502 17.1929 21.134 17.1929 21.1177C17.2091 21.0688 17.2336 21.0078 17.2661 20.9346C17.2987 20.8613 17.3312 20.7759 17.3638 20.6782C17.4289 20.4992 17.5184 20.2917 17.6323 20.0557C17.7463 19.8197 17.8765 19.5715 18.0229 19.311C18.3159 18.7576 18.6781 18.2002 19.1094 17.6387C19.5407 17.0771 20.0249 16.6174 20.562 16.2593C21.1479 15.8687 21.742 15.5472 22.3442 15.2949C22.9465 15.0426 23.4917 14.8433 23.98 14.6968C24.2404 14.6154 24.4723 14.5503 24.6758 14.5015C24.8792 14.4526 25.0542 14.4119 25.2007 14.3794C25.2658 14.3631 25.3268 14.3509 25.3838 14.3428C25.4408 14.3346 25.4937 14.3306 25.5425 14.3306C25.5588 14.3143 25.575 14.3062 25.5913 14.3062C25.6076 14.3062 25.6157 14.3062 25.6157 14.3062H25.6401L25.5913 13.5249Z" fill="#4E4E53"/>
								  </g>
								  <defs>
								    <clipPath id="clip0_9_140">
								      <rect width="25" height="25" fill="white" transform="matrix(1 0 0 -1 0.640137 25.6099)"/>
								    </clipPath>
								  </defs>
								</svg>
		                	</span>
		                </a>
		            </div>
	            <?php endif; ?>
			</div>
		</div>
	</div>
</div>