<?php
$html_id = pxl_get_element_id($settings);
$show_star = $widget->get_setting('show_star');
?>
<div class="pxl-rating-box pxl-rating-box1">
	<div class="pxl-item-inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <div class="pxl-item-title" <?php pxl_print_html($widget->get_render_attribute_string( 'link_text' )); ?>>
            <?php echo esc_attr($settings['title'])?>
        </div>
		<div class="pxl-meta-content">
            <div class="pxl-item-number">
                <?php echo esc_attr($settings['number']); ?>
            </div>
            <?php if( $show_star == 'true' ) : ?>
                <div class="pxl-inner-star">
                    <span class="pxl-item--star pxl-item--<?php echo esc_attr($settings['style_star']); ?>-star">
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                        <i class="fa fa-star"></i>
                    </span>
                </div>
            <?php endif; ?>
		</div>
	</div>
</div>