<?php
$html_id = pxl_get_element_id($settings);
if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'link_text', 'href', $settings['link']['url'] );

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'link_text', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'link_text', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-inner-box pxl-inner-box1">
	<div class="pxl-item-inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <div class="pxl-inner-top">
            <h5 class="pxl-item-heading">
                <?php echo esc_attr($settings['heading']); ?>
            </h5>
        </div>
        <div class="pxl-item-desc">
            <?php echo esc_attr($settings['desc']); ?>
        </div>
        <div class="pxl-content-btn">
            <a class="pxl-item-btn" <?php pxl_print_html($widget->get_render_attribute_string( 'link_text' )); ?>>
                <span class="pxl-btn-text">
                    <?php echo esc_attr($settings['btn_text'])?>
                </span>
                <span class="pxl-btn-icon">
                   <svg width="14" height="13" viewBox="0 0 14 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M8.60938 1.13867L13.4717 6.01367C13.624 6.15755 13.7002 6.33529 13.7002 6.54688C13.7002 6.75846 13.624 6.94043 13.4717 7.09277L8.60938 11.9551C8.45703 12.1074 8.27506 12.1836 8.06348 12.1836C7.85189 12.1836 7.67415 12.1074 7.53027 11.9551C7.37793 11.8112 7.30176 11.6335 7.30176 11.4219C7.30176 11.2103 7.37793 11.0283 7.53027 10.876L11.085 7.32129H1.46191C1.25033 7.32129 1.07048 7.24512 0.922363 7.09277C0.774251 6.94043 0.700195 6.75846 0.700195 6.54688C0.700195 6.33529 0.774251 6.15544 0.922363 6.00732C1.07048 5.85921 1.25033 5.78516 1.46191 5.78516H11.085L7.53027 2.23047C7.37793 2.07812 7.30176 1.89616 7.30176 1.68457C7.30176 1.47298 7.37793 1.29102 7.53027 1.13867C7.67415 0.994792 7.85189 0.922852 8.06348 0.922852C8.27506 0.922852 8.45703 0.994792 8.60938 1.13867Z" fill="#000"/>
                    </svg>
                </span>
            </a>
        </div>
	</div>
</div>