<?php
$html_id = pxl_get_element_id($settings);
if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'link_text', 'href', $settings['link']['url'] );

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'link_text', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'link_text', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-banner-box pxl-banner-box1 <?php echo esc_attr($settings['pxl_animate'].' '.$settings['popular']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">
        <?php if(!empty($settings['image']['id'])) : 
            $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '788x358'; 
            $img = pxl_get_image_by_size( array(
                'attach_id'  => $settings['image']['id'],
                'thumb_size' => $image_size,
            ));
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="pxl-item--img hover-imge-effect3">
                <?php echo pxl_print_html($thumbnail); ?>
            </div>
        <?php endif; ?>
        <div class="pxl-item-content">
            <a class="pxl-item-title" <?php pxl_print_html($widget->get_render_attribute_string( 'link_text' )); ?>>
                <?php echo esc_attr($settings['title'])?>
            </a>
            <div class="pxl-item-desc">
                <?php echo esc_attr($settings['desc'])?>
            </div>
            <div class="pxl-item-btn">
                <a class="btn pxl-icon-active  btn-default  pxl-icon--right" <?php pxl_print_html($widget->get_render_attribute_string( 'link_text' )); ?>>
                    <span class="pxl-btn-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" class="pxl-icon-arrow-right" width="24" height="24" viewBox="0 0 24 24" fill="none"><path d="M13 5L20 12M20 12L13 19M20 12H4" stroke="#03045E" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                    </span>
                    <span class="pxl--btn-text">
                        <?php echo esc_attr($settings['title_btn'])?>
                    </span>
                </a>
            </div>
        </div>
    </div>
</div>