;(function ($) {

    "use strict";
    
    var pxl_scroll_top;
    var pxl_window_height;
    var pxl_window_width;
    var pxl_scroll_status = '';
    var pxl_last_scroll_top = 0;
    var pxl_post_slip = false;
    var pxl_image_slip = false;

    $(window).on('load', function () {
        $('.pxl-circle-svg svg').each(function () {
            maxcare_circle_svg(this);
        });

        $('.pxl-swiper-slider, .pxl-header-mobile-elementor').css('opacity', '1');
        $('.pxl-gallery-scroll').parents('body').addClass('body-overflow').addClass('body-visible-sm');
        pxl_window_width = $(window).width();
        pxl_window_height = $(window).height();
        maxcare_loader();
        maxcare_header_sticky();
        maxcare_header_mobile();
        maxcare_scroll_to_top();
        maxcare_footer_fixed();
        maxcare_shop_quantity();
        maxcare_submenu_responsive();
        maxcare_panel_anchor_toggle();
        maxcare_post_grid();
        maxcare_slider_column_offset();
        maxcare_height_ct_grid();
        updateMegaMenuWidth();
    });

    $(window).on('scroll', function () {
        pxl_scroll_top = $(window).scrollTop();
        pxl_window_height = $(window).height();
        pxl_window_width = $(window).width();
        if (pxl_scroll_top < pxl_last_scroll_top) {
            pxl_scroll_status = 'up';
        } else {
            pxl_scroll_status = 'down';
        }
        pxl_last_scroll_top = pxl_scroll_top;
        maxcare_header_sticky();
        maxcare_scroll_to_top();
        maxcare_footer_fixed();
        maxcare_ptitle_scroll_opacity();
        maxcare_post_slip();
        if (pxl_scroll_top < 100) {
            $('.elementor > .pin-spacer').removeClass('scroll-top-active');
        }
    });

    $(window).on('resize', function () {
        pxl_window_height = $(window).height();
        pxl_window_width = $(window).width();
        maxcare_submenu_responsive();
        maxcare_header_mobile();
        maxcare_post_grid();
        maxcare_slider_column_offset();
    });

    $(document).ready(function () {
        maxcare_button_parallax();
        maxcare_backtotop_progess_bar();
        maxcare_type_file_upload();
        maxcare_zoom_point();
        maxcare_post_slip();
        maxcare_text_scroll_bar();
        maxcare_text_scroll_progress_bar();

        $('.pxl-portfolio-click1 .pxl-swiper-single:first-child').addClass('swiper-slide-active');

        $('.pxl-portfolio-click1 .pxl-swiper-single').on('click', function() {
            $('.pxl-portfolio-click1 .pxl-swiper-single').removeClass('swiper-slide-active');
            $(this).addClass('swiper-slide-active');
        });

        /* Start Menu Mobile */
        $('.pxl-header-menu li.menu-item-has-children').append('<span class="pxl-menu-toggle"></span>');
        $('.pxl-menu-toggle').on('click', function () {
            if( $(this).hasClass('active')){
                $(this).closest('ul').find('.pxl-menu-toggle.active').toggleClass('active');
                $(this).closest('ul').find('.sub-menu.active').toggleClass('active').slideToggle();    
            }else{
                $(this).closest('ul').find('.pxl-menu-toggle.active').toggleClass('active');
                $(this).closest('ul').find('.sub-menu.active').toggleClass('active').slideToggle();
                $(this).toggleClass('active');
                $(this).parent().find('> .sub-menu').toggleClass('active');
                $(this).parent().find('> .sub-menu').slideToggle();
            }      
        });
    
        $("#pxl-nav-mobile, .pxl-anchor-mobile-menu").on('click', function () {
            $(this).toggleClass('active');
            $('body').toggleClass('body-overflow');
            $('.pxl-header-menu').toggleClass('active');
        });

        $(".pxl-menu-close, .pxl-header-menu-backdrop, #pxl-header-mobile .pxl-menu-primary a.is-one-page").on('click', function () {
            $(this).parents('.pxl-header-main').find('.pxl-header-menu').removeClass('active');
            $('#pxl-nav-mobile').removeClass('active');
            $('body').toggleClass('body-overflow');
        });
        /* End Menu Mobile */

        /* Menu Style Box2 */
        $('.pxl-nav-menu.fr-style-box2 .pxl-menu-primary > li').on('mouseenter', function () {
            $(this).removeClass('hoverd').siblings().addClass('hoverd');
        });

        $('.pxl-nav-menu.fr-style-box2 .pxl-menu-primary > li').on('mouseleave', function () {
            $(this).removeClass('hoverd').siblings().removeClass('hoverd');
        });

        // Append arrow icon to menu items that have children
        const $menuItems = $('.pxl-nav-menu.fr-style-box2 li.menu-item-has-children > a');
        $menuItems.append('<span class="pxl-arrow-toggle"><i class="fas fa-chevron-right"></i></span>');

        $('.pxl-nav-menu.fr-style-box2 li.menu-item-has-children.current-menu-ancestor, .pxl-nav-menu.fr-style-box2 li.menu-item-has-children.current-menu-item').each(function () {
            const $this = $(this);
            const $link = $this.children('a');
            const $subMenu = $this.children('.sub-menu');

            $link.addClass('active');
            $subMenu.addClass('active').slideDown(0); // Không animation khi load
        });

        $menuItems.on('mouseenter', function () {
            const $this = $(this);
            const $subMenu = $this.next('.sub-menu');
            const $closestUl = $this.closest('ul');
            const $activeSubMenu = $closestUl.find('.sub-menu.active');
            const $activeLink = $closestUl.find('a.active');

            if ($this.hasClass('active')) {
                return;
            }

            $activeSubMenu.removeClass('active').slideUp(300);
            $activeLink.removeClass('active');

            $this.addClass('active');
            $subMenu.addClass('active').slideDown(300);
        });
        /* End Style Box2 */

        /* Button Onepage */
        if($('.pxl-atc-onepage').length) {
            $('.pxl-atc-onepage .btn').on('click', function (e) {
                var _this = $(this);
                var _link = $(this).attr('href');
                var _id_data = e.currentTarget.hash;
                var _offset;
                var _data_offset = $(this).attr('data-onepage-offset');
                if(_data_offset) {
                    _offset = _data_offset;
                } else {
                    _offset = 0;
                }
                if ($(_id_data).length === 1) {
                    var _target = $(_id_data);
                    $('.pxl-onepage-active').removeClass('pxl-onepage-active');
                    _this.addClass('pxl-onepage-active');
                    $('html, body').stop().animate({ scrollTop: _target.offset().top - _offset }, 1000);   
                    return false;
                } else {
                    window.location.href = _link;
                }
                return false;
            });
        }
        /* End */

        /* Copy Link Post */
        const copyBtn = document.querySelector('.js-copy-url');
        if (copyBtn) {
            copyBtn.addEventListener('click', function (e) {
                e.preventDefault();
                const url = window.location.href;

                navigator.clipboard.writeText(url).then(function () {
                    alert('URL copied to clipboard!');
                }).catch(function (err) {
                    console.error('Copy failed', err);
                });
            });
        }
        /* End */
        
        /* Menu Vertical */
        $('.pxl-nav-vertical li.menu-item-has-children > a').append('<span class="pxl-arrow-toggle"><i class="flaticon-right-arrow"></i></span>');
        $('.pxl-nav-vertical li.menu-item-has-children > a').on('click', function () {
            if( $(this).hasClass('active')){
                $(this).next().toggleClass('active').slideToggle(); 
            }else{
                $(this).closest('ul').find('.sub-menu.active').toggleClass('active').slideToggle();
                $(this).closest('ul').find('a.active').toggleClass('active');
                $(this).find('.pxl-menu-toggle.active').toggleClass('active');
                $(this).toggleClass('active');
                $(this).next().toggleClass('active').slideToggle();
            }   
        });


        /* Mega Menu Max Height */
        var m_h_mega = $('li.pxl-megamenu > .sub-menu > .pxl-mega-menu-elementor').outerHeight();
        var w_h_mega = $(window).height();
        var w_h_mega_css = w_h_mega - 120;
        if(m_h_mega > w_h_mega) {
            $('li.pxl-megamenu > .sub-menu > .pxl-mega-menu-elementor').css('max-height', w_h_mega_css + 'px');
            $('li.pxl-megamenu > .sub-menu > .pxl-mega-menu-elementor').css('overflow-x', 'scroll');
        }
        /* End Mega Menu Max Height */

        /* Scroll To Top */
        $('.pxl-scroll-top').on('click', function() {
            $('html, body').animate({scrollTop: 0}, 1200);
            $(this).parents('.pxl-wapper').find('.elementor > .pin-spacer').addClass('scroll-top-active');
            return false;
        });

        /* Animate Time Delay */
        $('.pxl-grid-masonry').each(function () {
            var eltime = 80;
            var elt_inner = $(this).children().length;
            var _elt = elt_inner - 1;
            $(this).find('> .pxl-grid-item > .wow').each(function (index, obj) {
                $(this).css('animation-delay', eltime + 'ms');
                if (_elt === index) {
                    eltime = 80;
                    _elt = _elt + elt_inner;
                } else {
                    eltime = eltime + 80;
                }
            });
        });

        $('.btn-text-nina').each(function () {
            var eltime = 0.045;
            var elt_inner = $(this).children().length;
            var _elt = elt_inner - 1;
            $(this).find('> .pxl--btn-text > span').each(function (index, obj) {
                $(this).css('transition-delay', eltime + 's');
                eltime = eltime + 0.045;
            });
        });

        $('.btn-text-nanuk').each(function () {
            var eltime = 0.05;
            var elt_inner = $(this).children().length;
            var _elt = elt_inner - 1;
            $(this).find('> .pxl--btn-text > span').each(function (index, obj) {
                $(this).css('animation-delay', eltime + 's');
                eltime = eltime + 0.05;
            });
        });

        $('.btn-text-smoke').each(function () {
            var eltime = 0.05;
            var elt_inner = $(this).children().length;
            var _elt = elt_inner - 1;
            $(this).find('> .pxl--btn-text > span > span > span').each(function (index, obj) {
                $(this).css('--d', eltime + 's');
                eltime = eltime + 0.05;
            });
        });

        $('.btn-text-reverse .pxl-text--front, .btn-text-reverse .pxl-text--back').each(function () {
            var eltime = 0.05;
            var elt_inner = $(this).children().length;
            var _elt = elt_inner - 1;
            $(this).find('.pxl-text--inner > span').each(function (index, obj) {
                $(this).css('transition-delay', eltime + 's');
                eltime = eltime + 0.05;
            });
        });

        $('.pxl-services-list .pxl--item .pxl-item-title').each(function () {
            const container = this;
            const image = container.querySelector('.pxl-image');

            if (image) {
                container.addEventListener("mousemove", (event) => {
                    const rect = container.getBoundingClientRect();
                    const x = event.clientX - rect.left;
                    const y = event.clientY - rect.top;

                    gsap.to(image, {
                        duration: 0.1,
                        top: `${y}px`,
                        left: `${x}px`,
                        ease: "power2.out",
                        overwrite: "auto"
                    });
                });
            }
        });

        $('.pxl-parent-transition').each(function() {
            $(this).find('.pxl-transtion').addClass('pxl-hover-transition');
            $(this).hover(function() {
                $(this).find('.pxl-transtion').addClass('pxl-hover-transition');
            });
            $('.pxl-switch-button').on('mouseover', function() {
                $(this).find('.pxl-transtion').removeClass('pxl-hover-transition');
            });
        });

        /* End Animate Time Delay */

        /* Lightbox Popup */
        $('.pxl-action-popup').magnificPopup({
            type: 'iframe',
            mainClass: 'mfp-fade',
            removalDelay: 160,
            preloader: false,
            fixedContentPos: false
        });

        $('.pxl-gallery-lightbox').each(function () {
            $(this).magnificPopup({
                delegate: 'a.lightbox',
                type: 'image',
                gallery: {
                    enabled: true
                },
                mainClass: 'mfp-fade',
            });
        });

        /* Page Title Parallax */
        if($('#pxl-page-title-default, #pxl-inner-post-sg-bg').hasClass('pxl--parallax')) {
            $(this).stellar();
        }

        /* Cart Sidebar Popup */
        $(".pxl-cart-sidebar-button").on('click', function () {
            $('body').addClass('body-overflow');
            $('#pxl-cart-sidebar').addClass('active');
        });
        $("#pxl-cart-sidebar .pxl-popup--overlay, #pxl-cart-sidebar .pxl-item--close").on('click', function () {
            $('body').removeClass('body-overflow');
            $('#pxl-cart-sidebar').removeClass('active');
        });

        /* Search Popup */
        $(".pxl-search-popup-button").on('click', function () {
            $('body').addClass('body-overflow');
            $('#pxl-search-popup').addClass('active');
            setTimeout(function(){
                $('#pxl-search-popup .search-field').focus();
            },1000);
        });
        $("#pxl-search-popup .pxl-item--overlay, #pxl-search-popup .pxl-item--close").on('click', function () {
            $('body').removeClass('body-overflow');
            $('#pxl-search-popup').removeClass('active');
        });

        /* Hidden Panel */
        $(".pxl-hidden-panel-button").on('click', function () {
            $('body').addClass('body-overflow');
            $('#pxl-hidden-panel-popup').addClass('active');
        });
        $("#pxl-hidden-panel-popup .pxl-item--overlay, #pxl-hidden-panel-popup .pxl-item--close").on('click', function () {
            $('body').removeClass('body-overflow');
            $('#pxl-hidden-panel-popup').removeClass('active');
        });

        /* Popup */
        $(".pxl-popup-button").on('click', function () {
            $('body').addClass('body-overflow');
            $('#pxl-popup-elementor').addClass('active');
            $('#pxl-popup-elementor').removeClass('deactivation');
        });
        $("#pxl-popup-elementor .pxl-item--overlay, #pxl-popup-elementor .pxl-item--close, .pxl-menu-primary a.is-one-page").on('click', function () {
            $('body').removeClass('body-overflow');
            $('#pxl-popup-elementor').removeClass('active');
            $('#pxl-popup-elementor').addClass('deactivation');
        });

        /* Hover Active Item */
        $('.pxl--widget-hover').each(function () {
            $(this).on('mouseover', function () {
                $(this).parents('.elementor-row').find('.pxl--widget-hover').removeClass('pxl--item-active');
                $(this).parents('.elementor-container').find('.pxl--widget-hover').removeClass('pxl--item-active');
                $(this).addClass('pxl--item-active');
            });
        });

        /* Item Hover Active */
        $('.pxl-hover-item').each(function () {
            $(this).hover(function () {
                $(this).parent('.pxl-hover-wrap').find('.pxl-hover-item').removeClass('pxl-active');
                $(this).addClass('pxl-active');
            });
        });
        /* End */

        /* SVG Animated*/
        var svgPaths = $('.pxl-icon-box3 svg path');
        var svgPaths_load = $('.pxl-icon-box3.drawPath.animated svg path');

        svgPaths.each(function() {
            var totalLength = this.getTotalLength();

            $(this).attr({
                'stroke-dashoffset': totalLength,
                'stroke-dasharray': totalLength,
            });
        });
        /*End*/

        /* PXL Video Scroll */
        if (window.gsap && window.ScrollTrigger && window.innerWidth >= 1367) {
          gsap.registerPlugin(ScrollTrigger);

          document.querySelectorAll('.pxl-video-scroll .pxl-video-section').forEach(sectionVideo => {
            const section = sectionVideo.closest('.pxl-video-scroll');
            if (!section) return;

            const noScrollSection = section.querySelector('.pxl-section-no-scroll');
            const btnVideo = section.querySelector('.pxl-video-section .pxl-btn-video');
            const titleVideo = section.querySelector('.pxl-title-video');
            const subtitleVideo = section.querySelector('.pxl-sub-title-video');

            // Set initial state
            gsap.set(sectionVideo, {
              y: 0,
              transformOrigin: "bottom right",
              opacity: 0,
            });

            gsap.set([btnVideo, titleVideo, subtitleVideo], {
                opacity: 0,
            });

            if (btnVideo) {
              gsap.set(btnVideo, {
                scale: 0.5,
                transformOrigin: "center center",
              });
            }

            if (titleVideo) {
              gsap.set(titleVideo, { x: 50 });
            }

            if (subtitleVideo) {
              gsap.set(subtitleVideo, { x: -50 });
            }

            const tl = gsap.timeline({
              scrollTrigger: {
                trigger: section,
                start: "bottom bottom",
                end: "+=900",
                pin: true,
                scrub: 1,
                anticipatePin: 1,
                markers: false
              }
            });

            tl.to(sectionVideo, {
              scale: 1,
              opacity: 1,
              ease: "power2.out"
            });

            if (noScrollSection) {
              tl.to(noScrollSection, {
                opacity: 0,
                scale: 1.2,
                ease: "power2.out"
              }, "<");
            }

            if (btnVideo) {
              tl.to(btnVideo, {
                scale: 1,
                opacity: 1,
                ease: "power2.out",
                duration: 0.25
              }, ">");
            }

            if (titleVideo) {
              tl.to(titleVideo, {
                x: 0,
                opacity: 1,
                ease: "power2.out",
                duration: 0.3
              }, ">");
            }

            if (subtitleVideo) {
              tl.to(subtitleVideo, {
                x: 0,
                opacity: 1,
                ease: "power2.out",
                duration: 0.3
              }, ">");
            }

            // Optional: toggle overflow-hidden using a class (less paint-heavy)
            ScrollTrigger.create({
              trigger: section,
              start: "top top",
              end: "bottom bottom",
              onEnter: () => document.body.classList.add("no-scroll"),
              onLeave: () => document.body.classList.remove("no-scroll"),
              onEnterBack: () => document.body.classList.add("no-scroll"),
              onLeaveBack: () => document.body.classList.remove("no-scroll")
            });
          });
        }
        /* End */

        /*PXL Service Process*/
        if (window.gsap && window.ScrollTrigger && window.innerWidth >= 1201) {
            const process_block = document.getElementById('process_block');
            if (process_block) {
                const processes = document.querySelectorAll('.wrap_item_process');

                gsap.set(process_block, {
                    height: (processes.length / 1.5) * window.innerHeight
                });

                const tl = gsap.timeline({
                    scrollTrigger: {
                        trigger: process_block,
                        scrub: true,
                        start: 'top -10%',
                        end: 'bottom bottom'
                    }
                });

                processes.forEach((proces, index) => {
                    const description = proces.querySelector('.pxl-list-bottom');
                    const descriptionLv2 = proces.querySelector('.pxl-list-bottom-lv2');

                    if (descriptionLv2) {
                        gsap.set(descriptionLv2, { autoAlpha: 0 });
                    }

                    if ((processes.length - 1) > index) {
                        tl.to(proces, {
                            width: 200,
                            ease: 'none'
                        });

                        tl.to(description, {
                            autoAlpha: 0,
                            y: -100,
                            ease: 'none'
                        }, '<');

                        tl.to(descriptionLv2, {
                            autoAlpha: 1,
                            y: 0,
                            ease: 'none'
                        }, '<');
                    }
                });
            }
        }
        /* End */

        $(".pxl-portfolio-modern1 .pxl-portfolio--content .pxl-portfolio--item")
        .on("mouseenter", function() {
            $(this).addClass("active permanent-active");          
            $(".pxl-portfolio-modern1 .pxl-portfolio--images .pxl-portfolio--featured").removeClass('active');       
            var selected_item = $(this).find(".pxl-content--inner").attr("data-image");
            $(selected_item).addClass('active').removeClass('non-active');
        })
        .on("mouseleave", function() {
            $(this).removeClass('active');
            $(".pxl-portfolio-modern1 .pxl-portfolio--images .pxl-portfolio--featured").removeClass('non-active');
            var selected_item = $(this).find(".pxl-content--inner").attr("data-image");
            $(selected_item).removeClass('active').addClass('non-active');
        });

        // CSS transition for smooth effect
        $(".pxl-portfolio-modern1 .pxl-portfolio--item, .pxl-portfolio-modern1 .pxl-list--images .pxl-list--featured")
            .css("transition", "all 0.3s ease");

        // Active Mega Menu Hover
        $('li.pxl-megamenu').hover(function(){
                $(this).parents('.elementor-section').addClass('section-mega-active');
            },function(){
                $(this).parents('.elementor-section').removeClass('section-mega-active');
        });

        // Service Sidebar //
        function updateChangeBox($link) {
            const $item = $link.closest('.pxl-item');
            const $sidebar = $link.closest('.pxl-service-sidebar1');
            const $changeBox = $sidebar.find('.pxl-item-change');

            const iconHtml = $item.find('.pxl-item--icon').html();
            const titleHtml = $item.find('.pxl-item-title').html();

            // Active link
            $sidebar.find('.pxl-item-link').removeClass('active');
            $link.addClass('active');

            // Update content
            $changeBox.html(`
                <div class="pxl-item--icon">${iconHtml}</div>
                <div class="pxl-item-title">${titleHtml}</div>
            `);
        }

        $('.pxl-service-sidebar1').on('click', '.pxl-item-link', function (e) {
            //e.preventDefault();
            updateChangeBox($(this));
        });

        const currentUrl = window.location.href;
        $('.pxl-service-sidebar1 .pxl-item-link').each(function () {
            const href = $(this).attr('href');
            if (href && currentUrl.includes(href)) {
                updateChangeBox($(this));
                return false;
            }
        });

        /* Start Icon Bounce */
        var boxEls = $('.el-bounce, .pxl-image-effect1, .el-effect-zigzag');
        $.each(boxEls, function(boxIndex, boxEl) {
            loopToggleClass(boxEl, 'active');
        });

        function loopToggleClass(el, toggleClass) {
            el = $(el);
            let counter = 0;
            if (el.hasClass(toggleClass)) {
                waitFor(function () {
                    counter++;
                    return counter == 2;
                }, function () {
                    counter = 0;
                    el.removeClass(toggleClass);
                    loopToggleClass(el, toggleClass);
                }, 'Deactivate', 1000);
            } else {
                waitFor(function () {
                    counter++;
                    return counter == 3;
                }, function () {
                    counter = 0;
                    el.addClass(toggleClass);
                    loopToggleClass(el, toggleClass);
                }, 'Activate', 1000);
            }
        }

        function waitFor(condition, callback, message, time) {
            if (message == null || message == '' || typeof message == 'undefined') {
                message = 'Timeout';
            }
            if (time == null || time == '' || typeof time == 'undefined') {
                time = 100;
            }
            var cond = condition();
            if (cond) {
                callback();
            } else {
                setTimeout(function() {
                    waitFor(condition, callback, message, time);
                }, time);
            }
        }
        /* End Icon Bounce */

        /* Image Effect */
        if($('.pxl-image-tilt').length){
            $('.pxl-image-tilt').parents('.elementor-top-section').addClass('pxl-image-tilt-active');
            $('.pxl-image-tilt').each(function () {
                var pxl_maxtilt = $(this).data('maxtilt'),
                    pxl_speedtilt = $(this).data('speedtilt'),
                    pxl_perspectivetilt = $(this).data('perspectivetilt');
                VanillaTilt.init(this, {
                    max: pxl_maxtilt,
                    speed: pxl_speedtilt,
                    perspective: pxl_perspectivetilt
                });
            });
        }

        /* Case Logo Fixed */
        $('.pxl-logo-fixed').each(function () {
            const box = this;
            const scrollThreshold = 0;
            let isFixed = false;
            const originalWidth = box.offsetWidth;
            const minWidth = 50;

            // Apply fixed position once
            Object.assign(box.style, {
                position: 'fixed',
                width: originalWidth + 'px',
                minWidth: minWidth + 'px'
            });

            let ticking = false;

            const onScroll = () => {
                if (!ticking) {
                    window.requestAnimationFrame(() => {
                        const scrollTop = window.scrollY;

                        if (scrollTop > scrollThreshold && !isFixed) {
                            isFixed = true;

                            gsap.to(box, {
                                duration: 0.2,
                                width: minWidth,
                                ease: 'power2.out',
                                overwrite: true,
                                onStart: () => {
                                    box.classList.add('is-fixed');
                                }
                            });

                        } else if (scrollTop <= scrollThreshold && isFixed) {
                            isFixed = false;

                            gsap.to(box, {
                                duration: 0.2,
                                width: originalWidth,
                                ease: 'power2.out',
                                overwrite: true,
                                onComplete: () => {
                                    box.classList.remove('is-fixed');
                                }
                            });
                        }

                        ticking = false;
                    });

                    ticking = true;
                }
            };

            window.addEventListener('scroll', onScroll);
        });
        /* End */

        /* Case Header Fixed */
        let last_scroll_position = 0;
        window.addEventListener('scroll', function () {
            const new_scroll_position = window.scrollY;
            const header = document.querySelector('.px-header--fixed');

            if (!header) return;

            if (new_scroll_position > 20) {
                header.classList.add("smaller");
            } else {
                header.classList.remove("smaller");
            }

            // Scrolling down
            if (new_scroll_position > last_scroll_position && new_scroll_position > 500) {
                header.classList.add("scroll-down");
                header.classList.remove("nav-up");
            }

            // Scrolling up
            else if (new_scroll_position < last_scroll_position) {
                header.classList.remove("scroll-down");
                header.classList.add("nav-up");
            }

            last_scroll_position = new_scroll_position;
        });
        /* End */

        /* Case Text Change */
        if (window.gsap && window.ScrollTrigger && window.innerWidth >= 1367) {
            gsap.registerPlugin(ScrollTrigger);

            const changeInner = document.querySelector(".pxl-text-change .pxl-change-inner");
            const heading = document.querySelector(".pxl-text-change .pxl--heading");
            const whiteText = document.querySelector(".pxl-text-change .pxl-whitetext");

            const innerlist = document.querySelector(".pxl-text-change .pxl-inner-list");
            const listblack = document.querySelector(".pxl-text-change .pxl-list-black");
            const listwhite = document.querySelector(".pxl-text-change .pxl-list-white");

            if (changeInner && heading && whiteText && innerlist && listblack && listwhite) {
                const hh = changeInner.offsetHeight;

                // Pin phần tử changeInner
                let tl = gsap.timeline({
                    scrollTrigger: {
                        trigger: changeInner,
                        start: "top top+=210",
                        endTrigger: ".container-panel",
                        end: "top top+=1",
                        invalidateOnRefresh: false,
                        pin: true,
                        pinSpacing: false,
                        markers: false,
                    },
                });

                // Hiện chữ trắng bằng clipPath
                gsap.to(whiteText, {
                    scrollTrigger: {
                        trigger: ".container-panel",
                        scrub: true,
                        start: "top top+=422",
                        end: () => "+=" + heading.offsetHeight,
                        id: "text-white",
                        markers: false,
                        invalidateOnRefresh: false
                    },
                    clipPath: "polygon(0% 0%, 100% 0%, 100% 100%, 0% 100%)",
                    ease: "none"
                });

                // Hiện danh sách đen
                gsap.to(listblack, {
                    scrollTrigger: {
                        trigger: ".container-panel",
                        scrub: true,
                        start: "top top+=317",
                        end: () => "+=" + innerlist.offsetHeight,
                        id: "list-black",
                        markers: false,
                        invalidateOnRefresh: false
                    },
                    clipPath: "polygon(0% 0%, 100% 0%, 100% 100%, 0% 100%)",
                    ease: "none"
                });

                // Ẩn danh sách trắng
                gsap.to(listwhite, {
                    scrollTrigger: {
                        trigger: ".container-panel",
                        scrub: true,
                        start: "top top+=317",
                        end: () => "+=" + innerlist.offsetHeight,
                        id: "list-white",
                        markers: false,
                        invalidateOnRefresh: false
                    },
                    opacity: 0,
                    ease: "none"
                });
            }
        }

        if (window.gsap && window.ScrollTrigger && window.innerWidth >= 1367) {
            gsap.registerPlugin(ScrollTrigger);

            const opcityInner = document.querySelector(".pxl-scopacity-inner");
            const scopacity = document.querySelector(".pxl-scopacity");

            if (opcityInner && scopacity) {
                const hh = opcityInner.offsetHeight;

                let tl = gsap.timeline({
                    scrollTrigger: {
                        trigger: opcityInner,
                        start: "top top+=470",
                        endTrigger: ".container-panel",
                        end: "top top+=1",
                        invalidateOnRefresh: false,
                        pin: true,
                        pinSpacing: false,
                        markers: false,
                    },
                });
                gsap.to(scopacity, {
                    scrollTrigger: {
                        trigger: ".container-panel",
                        scrub: true,
                        start: "top top",
                        end: () => "+=" + opcityInner.offsetHeight,
                        id: "section-opcity",
                        markers: false,
                        invalidateOnRefresh: false
                    },
                    opacity: 0,
                    ease: "none"
                });
            }
        }
        /* End */

        /* Related Post - Slick Slider */
        const postSlider = $(".pxl-related-post-inner");

        if (postSlider.length) {
            postSlider.slick({
                slidesToShow: 4,
                slidesToScroll: 1,
                infinite: true,
                arrows: true,
                dots: false,
                autoplay: false,
                pauseOnHover: true,
                prevArrow: $(".pxl-item-slick-arrow .slick-prev"),
                nextArrow: $(".pxl-item-slick-arrow .slick-next"),
                responsive: [
                    {
                        breakpoint: 1201,
                        settings: { slidesToShow: 3 }
                    },
                    {
                        breakpoint: 1025,
                        settings: { slidesToShow: 2 }
                    },
                    {
                        breakpoint: 576,
                        settings: { slidesToShow: 1 }
                    },
                ]
            });
        }
        /* End */

        /* Select Theme Style */
        $('.wpcf7-select').each(function(){
            var $this = $(this), numberOfOptions = $(this).children('option').length;
          
            $this.addClass('pxl-select-hidden'); 
            $this.wrap('<div class="pxl-select"></div>');
            $this.after('<div class="pxl-select-higthlight"></div>');

            var $styledSelect = $this.next('div.pxl-select-higthlight');
            $styledSelect.text($this.children('option').eq(0).text());
          
            var $list = $('<ul />', {
                'class': 'pxl-select-options'
            }).insertAfter($styledSelect);
          
            for (var i = 0; i < numberOfOptions; i++) {
                $('<li />', {
                    text: $this.children('option').eq(i).text(),
                    rel: $this.children('option').eq(i).val()
                }).appendTo($list);
            }
          
            var $listItems = $list.children('li');
          
            $styledSelect.on('click', function(e) {
                e.stopPropagation();
                $('div.pxl-select-higthlight.active').not(this).each(function(){
                    $(this).removeClass('active').next('ul.pxl-select-options').addClass('pxl-select-lists-hide');
                });
                $(this).toggleClass('active');
            });
          
            $listItems.on('click', function(e) {
                e.stopPropagation();
                $styledSelect.text($(this).text()).removeClass('active');
                $this.val($(this).attr('rel'));
            });
          
            $(document).on('click', function() {
                $styledSelect.removeClass('active');
            });

        });

        $('.wpcf7-select_custom').each(function(){
            var $this = $(this), numberOfOptions = $(this).children('option').length;

            // Ẩn select gốc và tạo ra giao diện tùy chỉnh
            $this.addClass('pxl-select-hidden');
            $this.wrap('<div class="pxl-select"></div>');
            $this.after('<div class="pxl-select-higthlight"></div>');

            var $styledSelect = $this.next('div.pxl-select-higthlight');
            $styledSelect.text($this.children('option').eq(0).text());

            var $list = $('<ul />', {
                'class': 'pxl-select-options'
            }).insertAfter($styledSelect);

            for (var i = 0; i < numberOfOptions; i++) {
                $('<li />', {
                    text: $this.children('option').eq(i).text(),
                    rel: $this.children('option').eq(i).val()
                }).appendTo($list);
            }

            var $listItems = $list.children('li');

            $styledSelect.on('click', function(e) {
                e.stopPropagation();
                $('div.pxl-select-higthlight.active').not(this).each(function(){
                    $(this).removeClass('active').next('ul.pxl-select-options').addClass('pxl-select-lists-hide');
                });
                $(this).toggleClass('active');
            });

            $listItems.on('click', function(e) {
                e.stopPropagation();
                $styledSelect.text($(this).text()).removeClass('active');
                $this.val($(this).attr('rel'));

                $this.trigger('change');
            });

            $(document).on('click', function() {
                $styledSelect.removeClass('active');
            });
        });


        /* Nice Select */
        $('.woocommerce-ordering .orderby, #pxl-sidebar-area select, .variations_form.cart .variations select, .pxl-open-table select, .pxl-nice-select').each(function () {
            $(this).niceSelect();
        });

        $('.pxl-post-list .nice-select').each(function () {
            $(this).niceSelect();
        });

        /* Text Scroll */
        
        //End//


        /* Typewriter */
        if($('.pxl-title--typewriter').length) {
            function typewriterOut(elements, callback)
            {
                if (elements.length){
                    elements.eq(0).addClass('is-active');
                    elements.eq(0).delay( 3000 );
                    elements.eq(0).removeClass('is-active');
                    typewriterOut(elements.slice(1), callback);
                }
                else {
                    callback();
                }
            }

            function typewriterIn(elements, callback)
            {
                if (elements.length){
                    elements.eq(0).addClass('is-active');
                    elements.eq(0).delay( 3000 ).slideDown(3000, function(){
                        elements.eq(0).removeClass('is-active');
                        typewriterIn(elements.slice(1), callback);
                    });
                }
                else {
                    callback();
                }
            }

            function typewriterInfinite(){
                typewriterOut($('.pxl-title--typewriter .pxl-item--text'), function(){ 
                    typewriterIn($('.pxl-title--typewriter .pxl-item--text'), function(){
                        typewriterInfinite();
                    });
                });
            }
            $(function(){
                typewriterInfinite();
            });
        }
        /* End Typewriter */

        /* Section Particles */      
        setTimeout(function() {
            $(".pxl-row-particles").each(function() {
                particlesJS($(this).attr('id'), {
                  "particles": {
                    "number": {
                        "value": $(this).data('number'),
                    },
                    "color": {
                        "value": $(this).data('color')
                    },
                    "shape": {
                        "type": "circle",
                    },
                    "size": {
                        "value": $(this).data('size'),
                        "random": $(this).data('size-random'),
                    },
                    "line_linked": {
                        "enable": false,
                    },
                    "move": {
                        "enable": true,
                        "speed": 2,
                        "direction": $(this).data('move-direction'),
                        "random": true,
                        "out_mode": "out",
                    }
                  },
                  "retina_detect": true
                });
            });
        }, 400);

        /* Get checked input - Mailchimpp */
        $('.mc4wp-form input:checkbox').change(function(){
            if($(this).is(":checked")) {
                $('.mc4wp-form').addClass("pxl-input-checked");
            } else {
                $('.mc4wp-form').removeClass("pxl-input-checked");
            }
        });

        /* Pricing */
        $('.pxl-pricing2 .pxl-pricing--body').each(function () {
            $(this).find('.pxl-item--first').on('mouseenter', function () {
                $(this).parent().addClass('pxl-item--first-active');
            }).on('mouseleave', function () {
                $(this).parent().removeClass('pxl-item--first-active');
            });
            $(this).find('.pxl-item--last').on('mouseenter', function () {
                $(this).parent().addClass('pxl-item--last-active');
            }).on('mouseleave', function () {
                $(this).parent().removeClass('pxl-item--last-active');
            });
        });

        $(".pxl-pricing2 .pxl-item--nav").on('click', function () {
            $(this).parent().toggleClass('active');
            $(this).parents('.pxl-pricing2').find('.pxl-pricing--monthly').toggleClass('pr-hide');
            $(this).parents('.pxl-pricing2').find('.pxl-pricing--year').toggleClass('pr-active');
        });
        /*end*/


        /* FadeIn JS */
        //Up//
        gsap.utils.toArray('.fadeInupJs').forEach((item) => {
            let delayAttr = item.getAttribute('data-wow-delay') || "0";
            let delay = parseFloat(delayAttr) / 1000;

            gsap.from(item, {
                y: 100,
                opacity: 0,
                duration: 1,
                ease: "power2.out",
                delay: delay,
                scrollTrigger: {
                    trigger: item,
                    start: "top 80%",
                    end: "top 10%",
                    toggleActions: 'play none none reverse',
                    markers: false,
                },
            });
        });

        //Down//
        gsap.utils.toArray('.fadeIndownJs').forEach((item) => {
            let delayAttr = item.getAttribute('data-wow-delay') || "0";
            let delay = parseFloat(delayAttr) / 1000;

            gsap.from(item, {
                y: -100,
                opacity: 0,
                duration: 1,
                ease: "power2.out",
                delay: delay,
                scrollTrigger: {
                    trigger: item,
                    start: "top 80%",
                    end: "top 10%",
                    toggleActions: 'play none none reverse',
                    markers: false,
                },
            });
        });

        //Left//
        gsap.utils.toArray('.fadeInLeftJs').forEach((item) => {
            let delayAttr = item.getAttribute('data-wow-delay') || "0";
            let delay = parseFloat(delayAttr) / 1000;

            gsap.from(item, {
                x: -100,
                opacity: 0,
                duration: 1,
                ease: "power2.out",
                delay: delay,
                scrollTrigger: {
                    trigger: item,
                    start: "top 80%",
                    end: "top 10%",
                    toggleActions: 'play none none reverse',
                    markers: false,
                },
            });
        });

        //Right//
        gsap.utils.toArray('.fadeInRightJs').forEach((item) => {
            let delayAttr = item.getAttribute('data-wow-delay') || "0";
            let delay = parseFloat(delayAttr) / 1000;

            gsap.from(item, {
                x: 100,
                opacity: 0,
                duration: 1,
                ease: "power2.out",
                delay: delay,
                scrollTrigger: {
                    trigger: item,
                    start: "top 80%",
                    end: "top 10%",
                    toggleActions: 'play none none reverse',
                    markers: false,
                },
            });
        });

        //Zoom//
        gsap.utils.toArray('.fadeInZoomJs').forEach((item) => {
            let delayAttr = item.getAttribute('data-wow-delay') || "0";
            let delay = parseFloat(delayAttr) / 1000;

            gsap.from(item, {
                scale: 0.8,
                opacity: 0,
                duration: 1,
                ease: "power2.out",
                delay: delay,
                scrollTrigger: {
                    trigger: item,
                    start: "top 80%",
                    end: "top 10%",
                    toggleActions: 'play none none reverse',
                    markers: false,
                },
            });
        });
        /*end*/


        /* Scroll to content */
        $('.pxl-link-to-section .btn').on('click', function(e) {
            var id_scroll = $(this).attr('href');
            var offsetScroll = $('.pxl-header-elementor-sticky').outerHeight();
            e.preventDefault();
            $("html, body").animate({ scrollTop: $(id_scroll).offset().top - offsetScroll }, 600);
        });

        // Hover Overlay Effect
        $('.pxl-overlay-shake').mousemove(function(event){ 
            var offset = $(this).offset();
            var W = $(this).outerWidth();
            var X = (event.pageX - offset.left);
            var Y = (event.pageY - offset.top);
            $(this).find('.pxl-overlay--color').css({
                'top' : + Y + 'px',
                'left' : + X + 'px'
            });
        });

        // Hover Portfolio Effect
        $(".pxl-portfolio-style1 .pxl-post--inner").on({
            mouseenter: function () {
                $(this).addClass("active-hover");
                $(this).removeClass("none-hover");
            },
            mouseleave: function () {
                $(this).removeClass("active-hover");
                $(this).addClass("none-hover");
            }
        });

        // Click Item Active
        const items = document.querySelectorAll(".pxl-service-click .pxl--item");

        if (items.length > 0) {
        items[0].classList.add("active");
        }

        items.forEach(item => {
        item.addEventListener("click", () => {
          items.forEach(i => i.classList.remove("active"));
          item.classList.add("active");
        });
        });
    });
    
    jQuery(document).ajaxComplete(function(event, xhr, settings){
        maxcare_shop_quantity();
    });

    jQuery( document ).on( 'updated_wc_div', function() {
        maxcare_shop_quantity();
    } );

    // Debounce function để giảm tần suất gọi scroll handler
    function debounce(func, wait, immediate) {
        let timeout;
        return function () {
            let context = this, args = arguments;
            let later = function () {
                timeout = null;
                if (!immediate) func.apply(context, args);
            };
            let callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) func.apply(context, args);
        };
    }
    $(window).on('scroll', debounce(maxcare_header_sticky, 10));
     
    /* Header Sticky */
    function maxcare_header_sticky() {
        var isInViewport = false;

        $('.pxl-tabs-slip').each(function () {
            var rect = this.getBoundingClientRect();
            if (rect.bottom >= 0 && rect.top <= window.innerHeight) {
                isInViewport = true;
                return false; 
            }
        });

        if (isInViewport) {
            return;
        }

        let navMenu = $('.px-header--default .pxl-nav-menu');
        let stickyElement = $('.pxl-header-elementor-sticky.pxl-sticky-stb');
        let scrollTop = $(window).scrollTop();
        let navMenuOffset = navMenu.length ? navMenu.offset().top : 0;
        let header = $('#pxl-header-elementor');
        let mobileHeader = $('#pxl-header-mobile');
        let scrollUpElement = $('.pxl-header-elementor-sticky.pxl-sticky-stt');

        if($('#pxl-header-elementor').hasClass('is-sticky')) {
            if (pxl_scroll_top > 100) {
                $('.pxl-header-elementor-sticky.pxl-sticky-stb').addClass('pxl-header-fixed');
                $('#pxl-header-mobile').addClass('pxl-header-mobile-fixed');
            } else {
                $('.pxl-header-elementor-sticky.pxl-sticky-stb').removeClass('pxl-header-fixed');
                $('#pxl-header-mobile').removeClass('pxl-header-mobile-fixed');
            }

            if (pxl_scroll_status == 'up' && pxl_scroll_top > 100) {
                $('.pxl-header-elementor-sticky.pxl-sticky-stt').addClass('pxl-header-fixed');
            } else {
                $('.pxl-header-elementor-sticky.pxl-sticky-stt').removeClass('pxl-header-fixed');
            }
        }

        $('.pxl-header-elementor-sticky').parents('body').addClass('pxl-header-sticky');
    }

    /* Header Mobile */
    function maxcare_header_mobile() {
        var h_header_mobile = $('#pxl-header-elementor').outerHeight();
        if(pxl_window_width < 1199) {
            $('#pxl-header-elementor').css('min-height', h_header_mobile + 'px');
        }
    }

    /* Scroll To Top */
    function maxcare_scroll_to_top() {
        if (pxl_scroll_top < pxl_window_height) {
            $('.pxl-scroll-top').addClass('pxl-off').removeClass('pxl-on');
        }
        if (pxl_scroll_top > pxl_window_height) {
            $('.pxl-scroll-top').addClass('pxl-on').removeClass('pxl-off');
        }
    }

    /* Footer Fixed */
    function maxcare_footer_fixed() {
        setTimeout(function(){
            var h_footer = $('.pxl-footer-fixed #pxl-footer-elementor').outerHeight() - 1;
            $('.pxl-footer-fixed #pxl-main').css('margin-bottom', h_footer + 'px');
        }, 600);
    }

    /* Image Slip */
    function maxcare_post_slip() {
        var windowHeight = window.innerHeight;
        var windowWidth = window.innerWidth;
        var scrollTop = $(window).scrollTop();

        jQuery('.pxl-post-image--track').each(function () {
            var topLimit = parseFloat(jQuery('.pxl-post-image--block').first().css('top'));
            var bottomLimit = parseFloat(jQuery('.pxl-post-image--block').first().outerHeight())
                + parseFloat(jQuery('.pxl-post-block_2').css('margin-top'));

            jQuery('.pxl-post-image--block').removeClass('end').each(function (is) {
                var currentTop = jQuery(this).offset().top - scrollTop - topLimit;

                var c = parseFloat(currentTop / bottomLimit);
                if (c < 0) c = 0;
                else if (c > 1) c = 1;

                if (c == 0 || is == 0){
                    jQuery(this).addClass('active');

                } else jQuery(this).removeClass('active');

                if (c < .5 || is == 0) jQuery(this).addClass('preactive');
                else jQuery(this).removeClass('preactive');
            });

            jQuery('.pxl-post-image--block.preactive').slice(0, -1).removeClass('active').addClass('end');
        });

        if ($('.pxl-image-slip, .pxl-post-slip').length) {
            var offsetTop = $('.pxl-image-slip, .pxl-post-slip').offset().top + (windowWidth >= 1200 ? 500 : 100) - windowHeight;
            if ((scrollTop >= offsetTop) && !pxl_image_slip) {
                for (var i = 1; i <= 20; i++) {
                    setTimeout(function(index) {
                        $(".pxl-post-block_" + index).addClass("slip-active");
                    }, 100 * i, i);
                }

                pxl_image_slip = true;
            }
        }
    }

    /* WooComerce Quantity */
    function maxcare_shop_quantity() {
        "use strict";
        $('#pxl-wapper .quantity').append('<span class="quantity-icon quantity-down pxl-icon--caretdown"></span><span class="quantity-icon quantity-up pxl-icon--caretup"></span>');
        $('.quantity-up').on('click', function () {
            $(this).parents('.quantity').find('input[type="number"]').get(0).stepUp();
            $(this).parents('.woocommerce-cart-form').find('.actions .button').removeAttr('disabled');
        });
        $('.quantity-down').on('click', function () {
            $(this).parents('.quantity').find('input[type="number"]').get(0).stepDown();
            $(this).parents('.woocommerce-cart-form').find('.actions .button').removeAttr('disabled');
        });
        $('.quantity-icon').on('click', function () {
            var quantity_number = $(this).parents('.quantity').find('input[type="number"]').val();
            var add_to_cart_button = $(this).parents( ".product, .woocommerce-product-inner" ).find(".add_to_cart_button");
            add_to_cart_button.attr('data-quantity', quantity_number);
            add_to_cart_button.attr("href", "?add-to-cart=" + add_to_cart_button.attr("data-product_id") + "&quantity=" + quantity_number);
        });
        $('.woocommerce-cart-form .actions .button').removeAttr('disabled');
    }

    /* Menu Responsive Dropdown */
    function maxcare_submenu_responsive() {
        var $maxcare_menu = $('.pxl-header-elementor-main, .pxl-header-elementor-sticky');
        $maxcare_menu.find('.pxl-menu-primary li').each(function () {
            var $maxcare_submenu = $(this).find('> ul.sub-menu');
            if ($maxcare_submenu.length == 1) {
                if ( ($maxcare_submenu.offset().left + $maxcare_submenu.width() + 0 ) > $(window).width()) {
                    $maxcare_submenu.addClass('pxl-sub-reverse');
                }
            }
        });
    }

    function maxcare_panel_anchor_toggle() {
        'use strict';
        $(document).on('click', '.pxl-anchor-button', function (e) {
            e.preventDefault();
            e.stopPropagation();
            var target = $(this).attr('data-target');
            $(target).toggleClass('active');
            $('.pxl-popup--conent .wow').addClass('animated').removeClass('aniOut');
            $('.pxl-popup--conent .fadeInPopup').removeClass('aniOut');
            if ($(target).find('.pxl-search-form').length > 0) {
                setTimeout(function () {
                    $(target).find('.pxl-search-form .pxl-search-field').focus();
                }, 1000);
            }
        });

        $('.pxl-anchor-button').each(function () {
            var t_target = $(this).attr('data-target');
            var t_delay = $(this).attr('data-delay-hover');
            $(t_target).find('.pxl-popup--conent').css('transition-delay', t_delay + 'ms');
            $(t_target).find('.pxl-popup--overlay').css('transition-delay', t_delay + 'ms');
        });

        $(".pxl-hidden-panel-popup .pxl-popup--overlay, .pxl-hidden-panel-popup .pxl-close-popup").on('click', function () {
            $('.pxl-hidden-panel-popup').removeClass('active');
            $('.pxl-popup--conent .wow').addClass('aniOut').removeClass('animated');
            $('.pxl-popup--conent .fadeInPopup').addClass('aniOut');
        });

        $(".pxl-button.pxl-atc-popup").on('click', function () {
            $('body').addClass('body-overflow');
            $(this).parents('.pxl-wapper').find('.pxl-page-popup').addClass('active');
        });

        $(".pxl-button-popup.pxl-atc-popup").on('click', function () {
            $('body').addClass('body-overflow');
            $(this).parents('.pxl-wapper').find('.pxl-popup-elementor-wrap').addClass('active');
        });

        $(".pxl-popup--close").on('click', function () {
            $('body').removeClass('body-overflow');
            $(this).parent().removeClass('active');
        });

        $(".pxl-popup--close, .pxl-item--overlay").on('click', function () {
            $(this).parent().removeClass('active');
        });
    }

    /* Post Grid */
    function maxcare_post_grid() {
        setTimeout(function(){
            $('.pxl-item--inner').each(function () {
                var item_w = $(this).outerWidth();
                var item_h = $(this).outerHeight();
                $(this).find('.pxl-item--imgfilter').css('width', item_w + 'px');
                $(this).find('.pxl-item--imgfilter').css('height', item_h + 'px');
            });
        }, 300);
    }

    /* Page Title Scroll Opacity */
    function maxcare_ptitle_scroll_opacity() {
        var divs = $('#pxl-page-title-elementor.pxl-scroll-opacity .elementor-widget'),
            limit = $('#pxl-page-title-elementor.pxl-scroll-opacity').outerHeight();
        if (pxl_scroll_top <= limit) {
            divs.css({ 'opacity' : (1 - pxl_scroll_top/limit)});
        }
    }

    /* Slider Column Offset */
    function maxcare_slider_column_offset() {
        var content_w = ($('#pxl-main').width() - 1200) / 2;
        if (pxl_window_width > 1200) {
            $('.pxl-slider2 .pxl-item--left').css('padding-left', content_w + 'px');
        }
    }

    /* Preloader Default */
    $.fn.extend({
        jQueryImagesLoaded: function () {
          var $imgs = this.find('img[src!=""]')

          if (!$imgs.length) {
            return $.Deferred()
              .resolve()
              .promise()
          }

          var dfds = []

          $imgs.each(function () {
            var dfd = $.Deferred()
            dfds.push(dfd)
            var img = new Image()
            img.onload = function () {
              dfd.resolve()
            }
            img.onerror = function () {
              dfd.resolve()
            }
            img.src = this.src
          })

          return $.when.apply($, dfds)
        }
    })

    /*** Star Rating ***/
    const stars = $(".star-rating label");
    const defaultRating = 5;

    function setStarRating(value) {
        stars.removeClass('selected');
        stars.each(function () {
            const starValue = parseInt($(this).data('value'), 10);
            if (starValue <= value) {
                $(this).addClass('selected');
            }
        });
    }

    setStarRating(defaultRating);

    stars.on('click', function () {
        const value = parseInt($(this).data('value'), 10);
        console.log('Star clicked:', value);
        setStarRating(value);
    });

    /*** Number Active Hover Effect ***/
    const numberItems = document.querySelectorAll('.pxl-number .pxl-item');

    numberItems.forEach((item, index) => {
        item.addEventListener('mouseenter', () => {
            numberItems.forEach(el => el.classList.remove('active'));
            for (let i = 0; i <= index; i++) {
                numberItems[i].classList.add('active');
            }
        });
    });
    /* End Number Active */

    /* Button Parallax */
    function maxcare_button_parallax() {
        $(document)
            .off('mouseenter.parallax mousemove.parallax mouseleave.parallax', '.btn-text-parallax, .pxl-list.style3 .pxl-item--icon')
            .on('mouseenter.parallax', '.btn-text-parallax, .pxl-list.style3 .pxl-item--icon', function () {
                const $text = $(this).find('svg');
                if ($text.length === 0) return;
                gsap.set($text, { transformOrigin: "50% 50%" });
            })
            .on('mousemove.parallax', '.btn-text-parallax, .pxl-list.style3 .pxl-item--icon', function (e) {
                const $btn = $(this);
                const $text = $btn.find('svg:not(.pxl-scroll-progress-circle), i, .pxl--btn-text');
                if ($text.length === 0) return;
                const { left, top, width, height } = this.getBoundingClientRect();
                const centerX = left + width / 2;
                const centerY = top + height / 2;
                const deltaX = (e.clientX - centerX) * 0.444;
                const deltaY = (e.clientY - centerY) * 0.444;
                gsap.to([$btn, $text], {
                    duration: 0.8,
                    x: deltaX,
                    y: deltaY,
                    ease: "power3.out"
                });
            })
            .on('mouseleave.parallax', '.btn-text-parallax, .pxl-list.style3 .pxl-item--icon', function () {
                const $btn = $(this);
                const $text = $btn.find('svg:not(.pxl-scroll-progress-circle), i, .pxl--btn-text');
                if ($text.length === 0) return;
                gsap.to([$btn, $text], {
                    duration: 0.8,
                    x: 0,
                    y: 0,
                    ease: "elastic.out(1, 0.3)"
                });
            });
    }

    /* Back To Top Progress Bar */
    function maxcare_backtotop_progess_bar() {
        if($('.pxl-scroll-top').length > 0) {
            var progressPath = document.querySelector('.pxl-scroll-top path');
            var pathLength = progressPath.getTotalLength();
            progressPath.style.transition = progressPath.style.WebkitTransition = 'none';
            progressPath.style.strokeDasharray = pathLength + ' ' + pathLength;
            progressPath.style.strokeDashoffset = pathLength;
            progressPath.getBoundingClientRect();
            progressPath.style.transition = progressPath.style.WebkitTransition = 'stroke-dashoffset 10ms linear';      
            var updateProgress = function () {
                var scroll = $(window).scrollTop();
                var height = $(document).height() - $(window).height();
                var progress = pathLength - (scroll * pathLength / height);
                progressPath.style.strokeDashoffset = progress;
            }
            updateProgress();
            $(window).scroll(updateProgress);   
            var offset = 50;
            var duration = 550;
            $(window).on('scroll', function() {
                if ($(this).scrollTop() > offset) {
                    $('.pxl-scroll-top').addClass('active-progress');
                } else {
                    $('.pxl-scroll-top').removeClass('active-progress');
                }
            });
        }
    }

    function maxcare_text_scroll_bar() {
        if ($('.pxl-text-scroll2 .pxl-list').length > 0) {
            var progressPath = document.querySelector('.barContainer .bar');
            var listContainer = $('.pxl-text-scroll2 .pxl-list');
            var listItems = $('.pxl-text-scroll2 .pxl-list .pxl-item');

            var totalHeight = listContainer[0].scrollHeight - listContainer.outerHeight();

            progressPath.style.transition = 'height 10ms linear';
            progressPath.style.height = '0%';

            var updateProgress = function () {
                var scroll = listContainer.scrollTop();
                var progress = (scroll / totalHeight) * 100;
                progressPath.style.height = progress + '%';
            };

            updateProgress();

            listContainer.on('scroll', updateProgress);

            var offset = 50;
            var duration = 550;
            $(window).on('scroll', function () {
                if ($(this).scrollTop() > offset) {
                    $('.pxl-scroll-top').addClass('active-progress');
                } else {
                    $('.pxl-scroll-top').removeClass('active-progress');
                }
            });
        }
    }

    function maxcare_text_scroll_progress_bar() {
        if ($('.pxl-text-scroll2 .pxl-list').length > 0) {
            var progressPath = document.querySelector('.load path');
            var listContainer = $('.pxl-text-scroll2 .pxl-list');
            var listItems = $('.pxl-text-scroll2 .pxl-list .pxl-item');

            var totalHeight = listContainer[0].scrollHeight - listContainer.outerHeight();

            var pathLength = progressPath.getTotalLength();
            progressPath.style.transition = progressPath.style.WebkitTransition = 'none';
            progressPath.style.strokeDasharray = pathLength + ' ' + pathLength;

            var startOffset = pathLength * 0.7;
            var endOffset = 0;

            progressPath.style.strokeDashoffset = startOffset;
            progressPath.getBoundingClientRect();

            progressPath.style.transition = progressPath.style.WebkitTransition = 'stroke-dashoffset 10ms linear';

            var updateProgress = function () {
                var scroll = listContainer.scrollTop();
                var progress = startOffset - (scroll * (startOffset - endOffset) / totalHeight);
                progressPath.style.strokeDashoffset = Math.max(progress, endOffset);
            };

            updateProgress();

            listContainer.on('scroll', updateProgress);

            var offset = 50;
            $(window).on('scroll', function () {
                if ($(this).scrollTop() > offset) {
                    $('.pxl-scroll-top').addClass('active-progress');
                } else {
                    $('.pxl-scroll-top').removeClass('active-progress');
                }
            });
        }
    }

    function maxcare_circle_svg(element) {
        var activeWidth = window.innerWidth || document.documentElement.clientWidth;
        if (activeWidth <= 1200) return;

        var svgEl = Snap(element);
        if (!svgEl) return;

        var path = svgEl.select('.pxl-circle-svg path');
        if (!path) return;

        var motionPath = path.getTotalLength();
        var dotEl1 = svgEl.select('#circle1');
        var dotEl2 = svgEl.select('#circle2');
        var dotEl3 = svgEl.select('#circle3');

        if (!dotEl1 || !dotEl2 || !dotEl3) return;

        dotEl1.appendTo(svgEl);
        dotEl2.appendTo(svgEl);
        dotEl3.appendTo(svgEl);

        // Reset vị trí
        dotEl1.transform('t0,0');
        dotEl2.transform('t0,0');
        dotEl3.transform('t0,0');

        var animation1, animation2, animation3;
        var isHovered = false;

        // Hàm animate chung
        function animateDot(dotEl, fromVal, toVal, duration, loop, reverse, offset) {
            return Snap.animate(fromVal, toVal, function (val) {
                var point = path.getPointAtLength(reverse ? (motionPath - val) : val);

                // offset để đẩy circle lên trên path
                var rad = Snap.rad(point.alpha); // đổi góc sang radian
                var nx = -Math.sin(rad);
                var ny = Math.cos(rad);

                var x = point.x + nx * offset;
                var y = point.y + ny * offset;

                dotEl.transform("t" + x + "," + y);
            }, duration, function () {
                if (!isHovered && loop) {
                    animateDot(dotEl, fromVal, toVal, duration, loop, reverse, offset);
                }
            });
        }

        function animateDot1(forward) {
            var fromVal = forward ? 0 : motionPath;
            var toVal   = forward ? motionPath : 0;
            animation1 = animateDot(dotEl1, fromVal, toVal, 15000, true, false, 8);
        }

        function animateDot2(forward) {
            var fromVal = forward ? motionPath : 0;
            var toVal   = forward ? 0 : motionPath;
            animation2 = animateDot(dotEl2, fromVal, toVal, 15000, true, true, 8);
        }

        function animateDot3(forward) {
            var fromVal = forward ? motionPath / 2 : motionPath;
            var toVal   = forward ? motionPath : 0;
            animation3 = animateDot(dotEl3, fromVal, toVal, 15000, true, false, 8);
        }

        // Bắt đầu chạy
        animateDot1(true);
        animateDot2(false);
        animateDot3(true);
    }

    /* Custom Loader */
    function maxcare_loader() {
        if( $('#pxl-loadding').hasClass('style-text')) {
            $('#pxl-loadding').addClass('hide');
            $(".loading-text").addClass("fadeout");
        } else {
            $(".pxl-loader").fadeOut("slow");
        }
    }

    /* Custom Type File Upload*/
    function maxcare_type_file_upload() {

        var multipleSupport = typeof $('<input/>')[0].multiple !== 'undefined',
        isIE = /msie/i.test( navigator.userAgent );

        $.fn.pxl_custom_type_file = function() {

            return this.each(function() {

            var $file = $(this).addClass('pxl-file-upload-hidden'),
            $wrap = $('<div class="pxl-file-upload-wrapper">'),
            $button = $('<button type="button" class="pxl-file-upload-button">Choose File</button>'),
            $input = $('<input type="text" class="pxl-file-upload-input" placeholder="No File Choose" />'),
            $label = $('<label class="pxl-file-upload-button" for="'+ $file[0].id +'">Choose File</label>');
            $file.css({
                position: 'absolute',
                opacity: '0',
                visibility: 'hidden'
            });

            $wrap.insertAfter( $file )
            .append( $file, $input, ( isIE ? $label : $button ) );

            $file.attr('tabIndex', -1);
            $button.attr('tabIndex', -1);

            $button.on('click', function() {
                $file.focus();
            });

            $file.change(function() {

            var files = [], fileArr, filename;

            if ( multipleSupport ) {
                fileArr = $file[0].files;
                for ( var i = 0, len = fileArr.length; i < len; i++ ) {
                files.push( fileArr[i].name );
                }
                filename = files.join(', ');
            } else {
                filename = $file.val().split('\\').pop();
            }

            $input.val( filename )
                .attr('title', filename)
                .focus();
            });

            $input.on({
                blur: function() { $file.trigger('blur'); },
                keydown: function( e ) {
                if ( e.which === 13 ) {
                    if ( !isIE ) { 
                        $file.trigger('click'); 
                    }
                } else if ( e.which === 8 || e.which === 46 ) {
                    $file.replaceWith( $file = $file.clone( true ) );
                    $file.trigger('change');
                    $input.val('');
                } else if ( e.which === 9 ){
                    return;
                } else {
                        return false;
                    }
                }
            });

            });

        };
        $('.wpcf7-file[type=file]').pxl_custom_type_file();
    }

    function updateMegaMenuWidth() {
        const megaMenus = document.querySelectorAll('.pxl-mega-menu');

        megaMenus.forEach(megaMenu => {
            const container = megaMenu.closest('.container-mega-menu');

            if (container) {
                const containerRect = container.getBoundingClientRect();
                const menuRect = megaMenu.getBoundingClientRect();

                const offsetLeft = containerRect.left - menuRect.left;

                megaMenu.style.position = 'absolute';
                megaMenu.style.width = containerRect.width + 'px';
                megaMenu.style.left = offsetLeft + 'px';
            }
        });
    }

    function maxcare_height_ct_grid($scope){
        $('.pxl-portfolio-carousel2 .pxl-swiper-slide').each(function () {
            var elementHeight = $(this).find(".pxl-post-content-hide").height();
            $(this).find(".pxl-post-content-hide").css("margin-bottom",  "-"+elementHeight + "px");     
        });
    }

    // Zoom Point
    function maxcare_zoom_point() {
        $(".pxl-zoom-point").each(function () {

            let scaleOffset = $(this).data('offset');
            let scaleAmount = $(this).data('scale-mount');

            function scrollZoom() {
                const images = document.querySelectorAll("[data-scroll-zoom]");
                let scrollPosY = 0;
                scaleAmount = scaleAmount / 100;

                const observerConfig = {
                    rootMargin: "0% 0% 0% 0%",
                    threshold: 0
                };

                images.forEach(image => {
                    let isVisible = false;
                    const observer = new IntersectionObserver((elements, self) => {
                        elements.forEach(element => {
                            isVisible = element.isIntersecting;
                        });
                    }, observerConfig);

                    observer.observe(image);

                    image.style.transform = `scale(${1 + scaleAmount * percentageSeen(image)})`;

                    window.addEventListener("scroll", () => {
                    if (isVisible) {
                        scrollPosY = window.pageYOffset;
                        image.style.transform = `scale(${1 +
                        scaleAmount * percentageSeen(image)})`;
                    }
                    });
                });

                function percentageSeen(element) {
                    const parent = element.parentNode;
                    const viewportHeight = window.innerHeight;
                    const scrollY = window.scrollY;
                    const elPosY = parent.getBoundingClientRect().top + scrollY + scaleOffset;
                    const borderHeight = parseFloat(getComputedStyle(parent).getPropertyValue('border-bottom-width')) + parseFloat(getComputedStyle(element).getPropertyValue('border-top-width'));
                    const elHeight = parent.offsetHeight + borderHeight;

                    if (elPosY > scrollY + viewportHeight) {
                        return 0;
                    } else if (elPosY + elHeight < scrollY) {
                        return 100;
                    } else {
                        const distance = scrollY + viewportHeight - elPosY;
                        let percentage = distance / ((viewportHeight + elHeight) / 100);
                        percentage = Math.round(percentage);

                        return percentage;
                    }
                }
            }

            scrollZoom();

        });
    }

})(jQuery);