(function($){

  $.fn.twentytwenty = function(options) {

    $('.twentytwenty-container').each(function () {
      $handle_text = $(this).attr('data-handle-text') || '';
    });

    var options = $.extend({
      default_offset_pct: 0.5,
      orientation: 'horizontal',
      no_overlay: true,
      move_slider_on_hover: false,
      move_with_handle_only: true,
      click_to_move: false,
      handle_text: $handle_text
    }, options);

    return this.each(function() {

      var sliderPct = options.default_offset_pct;
      var container = $(this);
      var sliderOrientation = options.orientation;

      container.wrap("<div class='twentytwenty-wrapper twentytwenty-" + sliderOrientation + "'></div>");

      var beforeImg = container.find("img:first");
      var afterImg = container.find("img:last");

      // Append handle and 2 dots
      container.append(
        "<div class='twentytwenty-handle'>" +
          "<span class='twentytwenty-handle-text'>" + (options.handle_text || '') + "</span>" +
        "</div>" +
        "<div class='handle-dot-top'></div>" +
        "<div class='handle-dot-bottom'></div>"
      );

      var slider = container.find(".twentytwenty-handle");

      container.addClass("twentytwenty-container");
      beforeImg.addClass("twentytwenty-before");
      afterImg.addClass("twentytwenty-after");

      var calcOffset = function(dimensionPct) {
        var w = beforeImg.width();
        var h = beforeImg.height();
        return {
          w: w + "px",
          h: h + "px",
          cw: (dimensionPct * w) + "px",
          ch: (dimensionPct * h) + "px"
        };
      };

      var adjustContainer = function(offset) {
        if (sliderOrientation === 'vertical') {
          beforeImg.css("clip", "rect(0," + offset.w + "," + offset.ch + ",0)");
          afterImg.css("clip", "rect(" + offset.ch + "," + offset.w + "," + offset.h + ",0)");
        } else {
          beforeImg.css("clip", "rect(0," + offset.cw + "," + offset.h + ",0)");
          afterImg.css("clip", "rect(0," + offset.w + "," + offset.h + "," + offset.cw + ")");
        }
        container.css("height", offset.h);
      };

      var adjustSlider = function(pct) {
        var offset = calcOffset(pct);
        if (sliderOrientation === "vertical") {
          slider.css("top", offset.ch);
        } else {
          slider.css("left", offset.cw);
        }
        adjustContainer(offset);

        // === Update dot positions based on handle position ===
        var handleOffset = sliderOrientation === 'vertical' ? slider.position().top : slider.position().left;

        container.find('.handle-dot-top, .handle-dot-bottom').each(function() {
          if (sliderOrientation === 'vertical') {
            $(this).css('top', handleOffset + 'px');
          } else {
            $(this).css('left', handleOffset + 'px');
          }
        });
      };

      var minMaxNumber = function(num, min, max) {
        return Math.max(min, Math.min(max, num));
      };

      var getSliderPercentage = function(positionX, positionY) {
        var sliderPercentage = (sliderOrientation === 'vertical') ?
          (positionY - offsetY) / imgHeight :
          (positionX - offsetX) / imgWidth;

        return minMaxNumber(sliderPercentage, 0, 1);
      };

      $(window).on("resize.twentytwenty", function() {
        adjustSlider(sliderPct);
      });

      var offsetX = 0;
      var offsetY = 0;
      var imgWidth = 0;
      var imgHeight = 0;

      var onMoveStart = function(e) {
        container.addClass("active");
        offsetX = container.offset().left;
        offsetY = container.offset().top;
        imgWidth = beforeImg.width();
        imgHeight = beforeImg.height();
      };

      var onMove = function(e) {
        if (container.hasClass("active")) {
          sliderPct = getSliderPercentage(e.pageX, e.pageY);
          adjustSlider(sliderPct);
        }
      };

      var onMoveEnd = function() {
        container.removeClass("active");
      };

      var moveTarget = options.move_with_handle_only ? slider : container;
      moveTarget.on("movestart", onMoveStart);
      moveTarget.on("move", onMove);
      moveTarget.on("moveend", onMoveEnd);

      if (options.move_slider_on_hover) {
        container.on("mouseenter", onMoveStart);
        container.on("mousemove", onMove);
        container.on("mouseleave", onMoveEnd);
      }

      slider.on("touchmove", function(e) {
        e.preventDefault();
      });

      container.find("img").on("mousedown", function(event) {
        event.preventDefault();
      });

      if (options.click_to_move) {
        container.on('click', function(e) {
          offsetX = container.offset().left;
          offsetY = container.offset().top;
          imgWidth = beforeImg.width();
          imgHeight = beforeImg.height();

          sliderPct = getSliderPercentage(e.pageX, e.pageY);
          adjustSlider(sliderPct);
        });
      }

      $(window).trigger("resize.twentytwenty");
    });
  };

})(jQuery);