;(function ($) {
    "use strict";

    var Pxl_Cursor = function() {
        var cursor = $(".pxl-cursor"),
            follower = $(".pxl-cursor-follower"),
            cursor_drag = $(".pxl-cursor-drag"),
            cursorText = $('.pxl-cursor-text');

        var posX = 0, posY = 0;
        var posX1 = 0, posY1 = 0;
        var mouseX = 0, mouseY = 0;

        if (cursor.length <= 0) return false;

        document.body.classList.add('pxl-cursor-init');

        $(document).on("mousemove", function (e) {
            mouseX = e.clientX;
            mouseY = e.clientY;
        });

        initCursor();
        extraCursor();

        function initCursor() {
            var cursor_width = cursor.width();
            var cursor_follower_width = follower.width();
            var cursor_drag_width = cursor_drag.width();
            var cursor_text_width = cursorText.width();

            gsap.to({}, {
                duration: 0.01,
                repeat: -1,
                onRepeat: function () {
                    posX += (mouseX - posX) / 9;
                    posY += (mouseY - posY) / 9;
                    posX1 += (mouseX - posX1);
                    posY1 += (mouseY - posY1);
                    
                    if (follower.length > 0) {
                        gsap.set(follower, {
                            css: {
                                left: posX - (cursor_follower_width / 2) - 2,
                                top: posY - (cursor_follower_width / 2) - 2
                            }
                        });
                    }
                    if (cursor.length > 0) {
                        gsap.set(cursor, {
                            css: {
                                left: mouseX - (cursor_width / 2),
                                top: mouseY - (cursor_width / 2)
                            }
                        });
                    }
                    if (cursor_drag.length > 0) {
                        gsap.set(cursor_drag, {
                            css: {
                                left: posX1 - (cursor_drag_width / 2),
                                top: posY1 - (cursor_drag_width / 2)
                            }
                        });
                    }
                    if (cursorText.length > 0) {
                        gsap.set(cursorText, {
                            css: {
                                left: posX1 - (cursor_text_width / 2),
                                top: posY1 - (cursor_text_width / 2)
                            }
                        });
                    }
                }
            });
        }

        function show_cursor(cur, bool) {
            cur.addClass("active");
            if (bool == true) {
                cursor.removeClass("active").addClass('hide');
                follower.removeClass("active").addClass('hide');
                
            }
        }

        function hide_cursor(cur, bool) {
            cur.removeClass("active");
            if (bool == true) {
                cursor.removeClass("hide");
                follower.removeClass("hide");
                
            }
        }

        function show_cursor_inner(e) {
            if ($(e).parents('.pxl-drag-area').length > 0) {
                cursor_drag.removeClass("active");
                cursor.removeClass("hide");
                follower.removeClass("hide");
                cursorText.removeClass("active");
            }
        }

        function hide_cursor_inner(e) {
            if ($(e).parents('.pxl-drag-area').length > 0) {
                cursor_drag.addClass("active");
                cursor.addClass("hide");
                follower.addClass("hide");
                cursorText.addClass("active");
            }
        }

        function extraCursor() {

            $('a').on("mouseenter", function () {
                show_cursor(cursor, false);
                show_cursor(follower, false);
                show_cursor_inner(this);
            });
            $('a').on("mouseleave", function () {
                hide_cursor(cursor, false);
                hide_cursor(follower, false);
                hide_cursor_inner(this);
            });

            $('.pxl-anchor').on("mouseenter", function () {
                show_cursor(cursor, false);
                show_cursor(follower, false);
            });
            $('.pxl-anchor').on("mouseleave", function () {
                hide_cursor(cursor, false);
                hide_cursor(follower, false);
            });

            $('.pxl-process-cards .pxl-cursor-content').on("mouseenter", function () {
                show_cursor(cursorText, true);
            });

            $('.pxl-process-cards .pxl-cursor-content').on("mouseleave", function () {
                hide_cursor(cursorText, true);
            });

            $('.pxl-image-box, .pxl-swiper-arrow, .btn-default').on("mouseenter", function () {
                show_cursor(cursor, false);
                show_cursor(follower, false);
            });
            $('.pxl-image-box, .pxl-swiper-arrow, .btn-default').on("mouseleave", function () {
                hide_cursor(cursor, false);
                hide_cursor(follower, false);
            });

            $('.pxl-swiper-arrow').on("mouseenter", function () {
                cursor_drag.addClass("hide");
            });

            $('.pxl-swiper-arrow').on("mouseenter", function () {
                cursor_drag.removeClass("hide");
            });

            $('.pxl-image-box, .pxl-swiper-arrow, .btn-default, a').on("mouseleave", function (e) {
                if (!$(e.relatedTarget).closest('.pxl-drag-area').length) {
                    cursorText.addClass("hide");
                }
            });

            $('.pxl-image-box, .pxl-swiper-arrow, .btn-default, a').on("mouseleave", function (e) {
                if (!$(e.relatedTarget).closest('.pxl-drag-area').length) {
                    cursorText.removeClass("hide");
                }
            });

            $('.pxl-drag-area').on("mouseenter", function () {
                show_cursor(cursor_drag, true);
                show_cursor(cursorText, false);
            });
            $('.pxl-drag-area').on("mouseleave", function () {
                hide_cursor(cursor_drag, true);
                hide_cursor(cursorText, false);
            });
            $(document).on('mousedown', '.pxl-drag-area, .pxl-process-cards .pxl-cursor-content', function () {
                cursor_drag.addClass("clicked");
                cursorText.addClass("clicked");
            });
            $(document).on('mouseup', '.pxl-drag-area, .pxl-process-cards .pxl-cursor-content', function () {
                cursor_drag.removeClass("clicked");
                cursorText.removeClass("clicked");
            });
        }
    };

    if ($(document).find('.pxl-cursor').length > 0) {
        if ($(window).innerWidth() >= 1200) {
            Pxl_Cursor();
        }
    }
})(jQuery);
